/****************************************************************************\
**  fsFileUtil.cpp
**
**      fsFileUtil.hpp supplies functions that operate on files.
**
**	Gigawatt Studios
**	Copyright(C) 2000 - All Rights Reserved
\****************************************************************************/

#include "stdafx.h"
#include "fsFileUtil.hpp"

#include <stdio.h>
#include <windows.h>

namespace fsFileUtil
{

namespace
{

void handle_windows_error(const std::string& i_Locator)
{
	// do something here, like throw exception
}

void handle_windows_multifile_error(const std::string& i_From, const std::string& i_To)
{

	// do something here, like throw exception
}

}

//============================================================================
//	FileCreate creates a file with the given name.  This must be done before
//	reading or writing with a fsFileStream.
//============================================================================
void FileCreate(const std::string& i_Filename)
{
	if( fsFileUtil::FileExists(i_Filename) )
		fsFileUtil::FileDelete(i_Filename);


	HANDLE new_file = INVALID_HANDLE_VALUE;

	new_file = ::CreateFile (	i_Filename.c_str(),
								GENERIC_WRITE,
								0,
								NULL,
								CREATE_NEW,
								FILE_ATTRIBUTE_NORMAL,
								NULL);

	if ( new_file == INVALID_HANDLE_VALUE )
		handle_windows_error(i_Filename);		// probably throws
	else
		::CloseHandle( new_file );	// release file so something else can write to it
}

//============================================================================
//	FileDelete deletes a file.  The file must exist, or an exception will be
//	thrown.
//============================================================================
void FileDelete(const std::string& i_Filename)
{
	BOOL ret_val =  ::DeleteFile (i_Filename.c_str());

	if( ret_val == 0 )
		handle_windows_error(i_Filename);
}

//============================================================================
//	FileExists tests if a file exists.
//
//============================================================================
bool FileExists(const std::string& i_Filename)
{
	DWORD ret_val = -1;

	ret_val = ::GetFileAttributes(i_Filename.c_str());

	if( (ret_val == -1) || (ret_val & FILE_ATTRIBUTE_DIRECTORY) )
		return false;
	else
		return true;
}


}
